from flask import Blueprint, request, jsonify
from werkzeug.utils import secure_filename
import os
from .predict import dummy_predict

api = Blueprint('api', __name__)

@api.route('/predict', methods=['POST'])
def predict():
    file = request.files.get('file')
    if not file:
        return jsonify({'error': 'No image uploaded'}), 400

    filename = secure_filename(file.filename)
    upload_path = os.path.join('app/static/uploads', filename)
    result_path = os.path.join('app/static/results', f'predicted_{filename}')

    file.save(upload_path)
    dummy_predict(upload_path, result_path)

    return jsonify({
        'image_url': f'https://ia.marqenti.tn/{result_path}'
    })
